unit Twav;

interface

uses
  SysUtils,WinTypes,WinProcs,Messages,Classes,Graphics,
  Controls,Forms,Dialogs,StdCtrls, MMSystem, Dsgnintf;

type
  TAboutProperty = class(TPropertyEditor)
  function GetAttributes : TPropertyAttributes; override;
  function GetValue : String; override;
  procedure edit; override;
  end;

type
  TSoundType = (stAsynchronous, stSynchronous, stLoop,
                stAsyncNoInt, stSyncNoInt, stLoopNoInt);

  TWAVPlayer = class(TComponent)
  private
    FAbout : string;
    FFileName : string;
    FSoundType : TSoundType;
    FWAVCapable : boolean;
    procedure SetFileName(Value:string);
    procedure SetSoundType(Value:TSoundType);
    procedure SetWAVCapable(Value:boolean);
  protected
  public
    constructor Create(AOwner:TComponent);override;
    Procedure Play;
    Procedure Stop;
  published
    property About : string read FAbout write FAbout;
    Property FileName : string read FFileName write SetFileName ;
    Property WAVCapable : boolean read FWAVCapable write SetWAVCapable ;
    property SoundType : TSoundType read FSoundType write SetSoundType default stAsynchronous;
    Property Name;
    Property Tag;
end;

procedure Register;


implementation

{================================================================================}

procedure Register;
begin
  RegisterPropertyEditor (TypeInfo(string), TWAVPlayer, 'About', TAboutProperty);
  RegisterComponents('Objects',[TWAVPlayer]);
end;

{================================================================================}

function TAboutProperty.GetAttributes : TPropertyAttributes;
{set the characteristics of the property editor}
begin
  result := [paDialog];
end;

function TAboutProperty.GetValue : String;
{this is the string that appears in the right hand column of the object inspector}
begin
  result := 'Click for Info';
end;

procedure TAboutProperty.Edit;
{invokes the actual property editor}
begin
  Application.MessageBox('Version 1.01, Created May 10, 1996 by' + chr(13) +
                         'Dennis Page, 73557.2357@CompuServe.COM' + chr(13) + chr(13) +
                         'To use this object, put a .WAV file name' + chr(13) +
                         'into the FileName property, then call the' + chr(13) +
                         'Play method.  The Stop method will stop a' + chr(13) +
                         '.WAV file that is currently playing.', 'TWAVPlayer', 0);
end;

{================================================================================}

constructor TWAVPlayer.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  SetWAVCapable(False);
  FFileName := '';
end;

procedure TWAVPlayer.SetFileName(Value:string);
begin
  if FFileName <> Value then
    {if FileExists(Value) then}  {I don't think I should do this here since the}
      FFileName := Value + #0;        {WAV file may not exist at design time}
end;

procedure TWAVPlayer.SetSoundType(Value:TSoundType);
begin
  if FSoundType <> Value then
    FSoundType := Value;
end;

procedure TWAVPlayer.SetWAVCapable(Value:boolean); {parameter unneeded}
begin
  if waveOutGetNumDevs > 0 then
    FWAVCapable := True;
end;

Procedure TWAVPlayer.Play;
var Flags : word;
begin
  flags := 0;
  if FWAVCapable = true then
    if FileExists(FFileName) then
      begin

      if FSoundType = stAsynchronous then
        flags := SND_ASYNC
      else if FSoundType = stSynchronous then
        flags := SND_SYNC
      else if FSoundType = stLoop then
        flags := SND_ASYNC + SND_LOOP
      else if FSoundType = stAsyncNoInt then
        flags := SND_ASYNC + SND_NOSTOP
      else if FSoundType = stSyncNoInt then
        flags := SND_SYNC + SND_NOSTOP
      else if FSoundType = stLoopNoInt then
        flags := SND_ASYNC + SND_LOOP + SND_NOSTOP;

      sndPlaySound(@FFileName[1], flags);
      end;
end;

Procedure TWAVPlayer.Stop;
begin
  if FWAVCapable = true then
    sndPlaySound(nil, SND_ASYNC);
end;

end.

